% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_clustering.R
\name{kmeans_haystack_raw}
\alias{kmeans_haystack_raw}
\title{Function for k-means clustering of genes according to their distribution on a 2D plot.}
\usage{
kmeans_haystack_raw(x, y, detection, genes, k, ...)
}
\arguments{
\item{x}{x-axis coordinates of cells in a 2D representation (e.g. resulting from PCA or t-SNE)}

\item{y}{y-axis coordinates of cells in a 2D representation}

\item{detection}{A logical matrix showing which genes (rows) are detected in which cells (columns)}

\item{genes}{A set of genes (of the 'detection' data) which will be clustered.}

\item{k}{The number of clusters to return.}

\item{...}{Additional parameters which will be passed on to the kmeans function.}
}
\value{
An object of class kmeans, describing a clustering into 'k' clusters
}
\description{
Function for k-means clustering of genes according to their distribution on a 2D plot.
}
\examples{
# using the toy example of the singleCellHaystack package
# define a logical matrix with detection of each gene (rows) in each cell (columns)
dat.detection <- dat.expression > 1

# running haystack in default mode
res <- haystack(dat.tsne, detection=dat.detection, method = "2D")

# get biased genes, store in variable gene.subset
sorted.table <- show_result_haystack(res, p.value.threshold = 1e-5)
gene.subset <- row.names(sorted.table)

# k-means clustering into 5 clusters
km <- kmeans_haystack(dat.tsne, detection=dat.detection, genes=gene.subset, k=5)
km.clusters <- km$cluster
}
