% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_namespace.R
\name{pretty_namespace}
\alias{pretty_namespace}
\title{Append namespace to functions in script}
\usage{
pretty_namespace(con = NULL, text = NULL, overwrite = FALSE,
  sos = FALSE)
}
\arguments{
\item{con}{character, path to file or directory that contains script, Default: NULL}

\item{text}{character, vector that contains script, Default: NULL}

\item{overwrite}{boolean, overwrite original file, Default: FALSE}

\item{sos}{boolean, apply sos search for uninstalled libraries, Default: FALSE}
}
\value{
character
}
\description{
Autoappend namespace to functions in script by searchpath order
}
\details{
searches for functions in the loadedNamespace, help.search and then \code{\link[sos]{findFn}}
}
\examples{
txt <- '#some comment
yy <- function(a=4){
  head(runif(10),a)
  # a comment
}

zz <- function(v=10,a=8){
  head(runif(v),a)
}'

pretty_namespace(text=txt)

}
\seealso{
\code{\link[sos]{findFn}}
 \code{\link[utils]{help.search}}
}
\author{
Jonathan Sidi
}
