% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-from-simulation.R
\name{model}
\alias{model}
\title{Get one or more models from a simulation}
\usage{
model(sim, ..., subset = NULL, reference = FALSE)
}
\arguments{
\item{sim}{a simulation object}

\item{...}{logical conditions to specify a subset of models.  Conditions can
only involve params of model that have length 1 and are of class
numeric or character.}

\item{subset}{a vector of integers indexing the models or a vector of model
names. To select models based on parameter values, use \code{...}.
However, using \code{...} is slower than using subset.}

\item{reference}{whether to return the ModelRef or the Model object itself}
}
\description{
Returns either the models themselves or references to them.
}
\details{
There are two main ways to specify a subset of the models.  (1) The easiest
way is by writing a conditional expression involving the parameters and
passing it through \code{...}.  For example, \code{n > 100 & p <= 20}.
Only parameters that are length one and either numeric or character can be
used in these expressions.  (2) The faster way to retrieve a subset of
models is to use the \code{subset} argument.  This can be either a set of
numerical values (specifying which models to load based on the order in
which the models are stored in the simulation object.  This order can be
ascertained by printing the simulation object.) or as a set of a character
vector of the model names desired.

While approach (1) is very convenient, it requires loading all models from
 file. This may be slow in situations in which there are a lot of models
 and/or the models are large and thus slow to load.
}

