# vectorizeObject: Change an object to a vector with labels

setMethod("vectorizeObject", signature(object = "vector", labels = "vector"), definition = function(object, labels) {
    result <- as.vector(object[!is.na(labels)])
    names(result) <- as.vector(labels[!is.na(labels)])
    return(result)
})

setMethod("vectorizeObject", signature(object = "matrix", labels = "matrix"), definition = function(object, labels, symmetric = FALSE) {
    result <- NULL
    if (symmetric) {
        object_lower <- object[lower.tri(object, diag = TRUE)]
        labels_lower <- labels[lower.tri(labels, diag = TRUE)]
        result <- vectorizeObject(object_lower, labels_lower)
    } else {
        result <- as.vector(object[!is.na(labels)])
        names(result) <- as.vector(labels[!is.na(labels)])
    }
    return(result)
})

setMethod("vectorizeObject", signature(object = "VirtualRSet", labels = "SimLabels"), definition = function(object, labels) {
    result <- NULL
    if (!isNullObject(labels@LX)) 
        result <- c(result, vectorizeObject(object@LX, labels@LX))
    if (!isNullObject(labels@LY)) 
        result <- c(result, vectorizeObject(object@LY, labels@LY))
    if (!isNullObject(labels@GA)) 
        result <- c(result, vectorizeObject(object@GA, labels@GA))
    if (!isNullObject(labels@BE)) 
        result <- c(result, vectorizeObject(object@BE, labels@BE))
    if (!isNullObject(labels@PH)) 
        result <- c(result, vectorizeObject(object@PH, labels@PH, symmetric = TRUE))
    if (!isNullObject(labels@PS)) 
        result <- c(result, vectorizeObject(object@PS, labels@PS, symmetric = TRUE))
    if (!isNullObject(labels@TD)) 
        result <- c(result, vectorizeObject(object@TD, labels@TD, symmetric = TRUE))
    if (!isNullObject(labels@TH)) 
        result <- c(result, vectorizeObject(object@TH, labels@TH))
    if (!isNullObject(labels@TE)) 
        result <- c(result, vectorizeObject(object@TE, labels@TE, symmetric = TRUE))
    if (!isNullObject(labels@KA)) 
        result <- c(result, vectorizeObject(object@KA, labels@KA))
    if (!isNullObject(labels@AL)) 
        result <- c(result, vectorizeObject(object@AL, labels@AL))
    if (!isNullObject(labels@TX)) 
        result <- c(result, vectorizeObject(object@TX, labels@TX))
    if (!isNullObject(labels@TY)) 
        result <- c(result, vectorizeObject(object@TY, labels@TY))
    return(result)
})

setMethod("vectorizeObject", signature(object = "MatrixSet", labels = "SimGenLabels"), definition = function(object, labels) {
    result <- NULL
    if (!isNullObject(labels@LX)) 
        result <- c(result, vectorizeObject(object@LX, labels@LX))
    if (!isNullObject(labels@LY)) 
        result <- c(result, vectorizeObject(object@LY, labels@LY))
    if (!isNullObject(labels@GA)) 
        result <- c(result, vectorizeObject(object@GA, labels@GA))
    if (!isNullObject(labels@BE)) 
        result <- c(result, vectorizeObject(object@BE, labels@BE))
    if (!isNullObject(labels@PH)) 
        result <- c(result, vectorizeObject(object@PH, labels@PH, symmetric = TRUE))
    if (!isNullObject(labels@PS)) 
        result <- c(result, vectorizeObject(object@PS, labels@PS, symmetric = TRUE))
    if (!isNullObject(labels@TD)) 
        result <- c(result, vectorizeObject(object@TD, labels@TD, symmetric = TRUE))
    if (!isNullObject(labels@TH)) 
        result <- c(result, vectorizeObject(object@TH, labels@TH))
    if (!isNullObject(labels@TE)) 
        result <- c(result, vectorizeObject(object@TE, labels@TE, symmetric = TRUE))
    if (!isNullObject(labels@KA)) 
        result <- c(result, vectorizeObject(object@KA, labels@KA))
    if (!isNullObject(labels@AL)) 
        result <- c(result, vectorizeObject(object@AL, labels@AL))
    if (!isNullObject(labels@TX)) 
        result <- c(result, vectorizeObject(object@TX, labels@TX))
    if (!isNullObject(labels@TY)) 
        result <- c(result, vectorizeObject(object@TY, labels@TY))
    if (!isNullObject(labels@RPS)) 
        result <- c(result, vectorizeObject(object@RPS, labels@RPS, symmetric = TRUE))
    if (!isNullObject(labels@RTE)) 
        result <- c(result, vectorizeObject(object@RTE, labels@RTE, symmetric = TRUE))
    if (!isNullObject(labels@RPH)) 
        result <- c(result, vectorizeObject(object@RPH, labels@RPH, symmetric = TRUE))
    if (!isNullObject(labels@RTD)) 
        result <- c(result, vectorizeObject(object@RTD, labels@RTD, symmetric = TRUE))
    if (!isNullObject(labels@VPS)) 
        result <- c(result, vectorizeObject(object@VPS, labels@VPS))
    if (!isNullObject(labels@VTE)) 
        result <- c(result, vectorizeObject(object@VTE, labels@VTE))
    if (!isNullObject(labels@VTD)) 
        result <- c(result, vectorizeObject(object@VTD, labels@VTD))
    if (!isNullObject(labels@VPH)) 
        result <- c(result, vectorizeObject(object@VPH, labels@VPH))
    if (!isNullObject(labels@VX)) 
        result <- c(result, vectorizeObject(object@VX, labels@VX))
    if (!isNullObject(labels@VY)) 
        result <- c(result, vectorizeObject(object@VY, labels@VY))
    if (!isNullObject(labels@VE)) 
        result <- c(result, vectorizeObject(object@VE, labels@VE))
    if (!isNullObject(labels@ME)) 
        result <- c(result, vectorizeObject(object@ME, labels@ME))
    if (!isNullObject(labels@MX)) 
        result <- c(result, vectorizeObject(object@MX, labels@MX))
    if (!isNullObject(labels@MY)) 
        result <- c(result, vectorizeObject(object@MY, labels@MY))
    if (!isNullObject(labels@RTH)) 
        result <- c(result, vectorizeObject(object@RTH, labels@RTH))
    return(result)
}) 
