% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_stars.R
\name{gg_stars}
\alias{gg_stars}
\title{Stars ggplot map.}
\usage{
gg_stars(
  data,
  borders = NULL,
  borders_on_top = TRUE,
  downsample = 0,
  pal = pal_viridis_reorder(1),
  pal_borders = "#323232",
  alpha_fill = 0.5,
  alpha_borders = 0.5,
  size_borders = 0.2,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(void = TRUE),
  mobile = FALSE
)
}
\arguments{
\item{data}{A stars object with defined coordinate reference system in a structure to be plotted untransformed. Note, it cannot be a stars_proxy object. Required input.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_on_top}{TRUE or FALSE  as to whether the borders are on top of the stars array. Defaults to TRUE.}

\item{downsample}{downsampling rate: e.g. 3 keeps rows and cols 1, 4, 7, 10 etc. A value of 0 does not downsample. It can be specified for each dimension. E.g. c(5,5,0) to downsample the first two dimensions but not the third.}

\item{pal}{Character vector of hex codes.}

\item{pal_borders}{Colour of the borders. Defaults to "#323232".}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.5.}

\item{alpha_borders}{Opacity of the borders. Defaults to 0.5.}

\item{size_borders}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Map of an array in ggplot that is not coloured and not facetted.
}
\examples{
library(simplevis)

gg_stars(example_stars, 
     borders = example_borders)
     
}
