% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_boxplot.R
\name{summarise_boxplot_stats}
\alias{summarise_boxplot_stats}
\title{Summarise boxplot stats in a dataset or tibble.}
\usage{
summarise_boxplot_stats(
  data,
  var,
  names_vctr = c("min", "lower", "middle", "upper", "max"),
  ...
)
}
\arguments{
\item{data}{A tibble or dataframe. Required input. Group the dataset as appropriate prior.}

\item{var}{Unquoted variable from which to calculate boxplot stats. Required input.}

\item{names_vctr}{A vector of names for the boxplot stats.}

\item{...}{Passed to \code{boxplot.stats}}
}
\value{
A tibble or dataframe.
}
\description{
Summarise boxplot stats in a dataset or tibble.
}
\examples{
library(simplevis)
library(dplyr)
library(palmerpenguins)

penguins \%>\% 
  group_by(species) \%>\% 
  summarise_boxplot_stats(body_mass_g) 

penguins \%>\% 
  group_by(sex, species) \%>\% 
  summarise_boxplot_stats(body_mass_g, names_vctr = LETTERS[1:5]) 
  
}
