% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_stars.R
\name{leaflet_stars}
\alias{leaflet_stars}
\title{Stars leaflet map.}
\usage{
leaflet_stars(data, pal = NULL, alpha = 0.5, basemap = "light", map_id = "map")
}
\arguments{
\item{data}{A stars object. Required input.}

\item{pal}{Character vector of hex codes.}

\item{alpha}{The opacity of the array values.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{map_id}{The shiny map id for a leaflet map within a shiny app. For standard single-map apps, id "map" should be used. For dual-map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of stars in leaflet that is not coloured.
}
\examples{
library(simplevis)
library(stars)

leaflet_stars(example_stars) 
  
}
