% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sf_fun.R
\name{ggplot_sf_facet}
\alias{ggplot_sf_facet}
\title{Map of simple features in ggplot that is facetted.}
\usage{
ggplot_sf_facet(data, facet_var, size = 0.5, alpha = 0.1, pal = NULL,
  facet_nrow = NULL, coastline = NULL, coastline_behind = TRUE,
  coastline_pal = "#7f7f7f", title = "[Title]", subtitle = NULL,
  caption = "", font_family = "Helvetica", font_size_title = 11,
  font_size_body = 10, wrap_title = 75, wrap_subtitle = 80,
  wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{size}{Size of points. Defaults to 0.5.}

\item{alpha}{The alpha of the fill. Defaults to 0.1. Only applicable to polygons.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{facet_nrow}{The number of rows of facetted plots. Not applicable to where isMobile is TRUE.}

\item{coastline}{Add a sf object as a coastline (or administrative boundaries). Defaults to NULL. Use nz (or nz_region) to add a new zealand coastline. Or add a custom sf object.}

\item{coastline_behind}{TRUE or FALSE  as to whether the coastline is to be behind the sf object defined in the data argument. Defaults to FALSE.}

\item{coastline_pal}{Colour of the coastline. Defaults to "#7F7F7F".}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 75. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shiny app, use input$isMobile if your app is able to retreive this input. A method to do this is described at https://g3rv4.com/2017/08/shiny-detect-mobile-browsers}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is facetted, but not coloured.
}
\examples{
map_data <- example_sf_nz_river_wq \%>\%
 dplyr::filter(period == "1998-2017", indicator == "Nitrate-nitrogen")

ggplot_sf_facet(data = map_data, facet_var = trend_category, coastline = nz,
  title = "Monitored river nitrate-nitrogen trends, 2008\\u201317")
}
