\name{coNetwork}
\alias{coNetwork}

\title{Random perturbations of a reference network}

\description{%
  Simulates a network from another network object by randomly perturbing
  a given number of edges.
}
\usage{%
coNetwork(graph,
          delta,
          name = "a co-network")}

\arguments{%
  \item{graph}{
    an object of class \code{simone.network} (typically generated by the
    \code{\link{rNetwork}} function).
  }
  \item{delta}{
    an integer giving the number of edges to randomly remove AND add to
    \code{graph} in order to obtain a randomly perturbed network.
  }
  \item{name}{
    a character string indicating the name of the perturbed network.
  }
}

\value{%
  Returns an object of class \code{simone.network}, see \code{rNetwork} for
  further details.
}

\author{J. Chiquet}

\seealso{\code{\link{rNetwork}}, \code{\link{plot.simone.network}}.}

\examples{%
## ancestor and child network generation
ancestor <- rNetwork(p = 20, pi = 20, name = "ancestor")
child    <- coNetwork(ancestor, delta = 1, name = "child")

# network comparison
plot(ancestor, child)
}

\keyword{graphs}
\keyword{datagen}
