% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_viz.simmr_output.R
\name{prior_viz}
\alias{prior_viz}
\title{Plot the prior distribution for a simmr run}
\usage{
prior_viz(
  simmr_out,
  group = 1,
  plot = TRUE,
  include_posterior = TRUE,
  n_sims = 10000
)
}
\arguments{
\item{simmr_out}{A run of the simmr model from \code{\link{simmr_mcmc}}}

\item{group}{Which group to run it for (currently only numeric rather than group names)}

\item{plot}{Whether to create a density plot of the prior or not. The simulated prior values are returned as part of the object}

\item{include_posterior}{Whether to include the posterior distribution on top of the priors. Defaults to TRUE}

\item{n_sims}{The number of simulations from the prior distribution}
}
\description{
This function takes the output from \code{\link{simmr_mcmc}} and plots the prior distribution to enable visual inspection. This can be used by itself or as part of \code{\link{posterior_predictive}} to visually evaluate the influence of the prior on the posterior distribution.
}
\examples{
\dontrun{
mix = matrix(c(-10.13, -10.72, -11.39, -11.18, -10.81, -10.7, -10.54, 
-10.48, -9.93, -9.37, 11.59, 11.01, 10.59, 10.97, 11.52, 11.89, 
11.73, 10.89, 11.05, 12.3), ncol=2, nrow=10)
colnames(mix) = c('d13C','d15N')
s_names=c('Source A','Source B','Source C','Source D')
s_means = matrix(c(-14, -15.1, -11.03, -14.44, 3.06, 7.05, 13.72, 5.96), ncol=2, nrow=4)
s_sds = matrix(c(0.48, 0.38, 0.48, 0.43, 0.46, 0.39, 0.42, 0.48), ncol=2, nrow=4)
c_means = matrix(c(2.63, 1.59, 3.41, 3.04, 3.28, 2.34, 2.14, 2.36), ncol=2, nrow=4)
c_sds = matrix(c(0.41, 0.44, 0.34, 0.46, 0.46, 0.48, 0.46, 0.66), ncol=2, nrow=4)
conc = matrix(c(0.02, 0.1, 0.12, 0.04, 0.02, 0.1, 0.09, 0.05), ncol=2, nrow=4)

# Load into simmr
simmr_1 = simmr_load(mixtures=mix,
                     source_names=s_names,
                     source_means=s_means,
                     source_sds=s_sds,
                     correction_means=c_means,
                     correction_sds=c_sds,
                     concentration_means = conc)

# Plot
plot(simmr_1)

# Print
simmr_1

# MCMC run
simmr_1_out = simmr_mcmc(simmr_1)

# Prior predictive
prior = prior_viz(simmr_1_out)
head(prior)
summary(prior)
}
}
