% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{branch}
\alias{branch}
\title{Fork the Trajectory Path}
\usage{
branch(.trj, option, continue, ...)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{option}{a callable object (a function) which must return an integer between
\code{0} and \code{N}. A return value equal to \code{0} skips the branch and
continues to the next activity. A returning value between \code{1} to \code{N}
makes the arrival to follow the corresponding sub-trajectory.}

\item{continue}{a vector of \code{N} booleans that indicate whether the arrival
must continue to the main trajectory after each sub-trajectory or not (if only
one value is provided, it will be recycled to match the number of sub-trajectories).}

\item{...}{\code{N} trajectory objects (or a list of \code{N} trajectory objects)
describing each sub-trajectory.}
}
\value{
Returns the trajectory object.
}
\description{
Activity for defining a fork with \code{N} alternative sub-trajectories.
}
\examples{
env <- simmer()

traj <- trajectory() \%>\%
  set_global("path", 1, mod="+", init=-1) \%>\%
  log_(function() paste("Path", get_global(env, "path"), "selected")) \%>\%
  branch(
    function() get_global(env, "path"), continue=c(TRUE, FALSE),
    trajectory() \%>\%
      log_("following path 1"),
    trajectory() \%>\%
      log_("following path 2")) \%>\%
  log_("continuing after the branch (path 0)")

env \%>\%
  add_generator("dummy", traj, at(0:2)) \%>\%
  run() \%>\% invisible

}
