% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap-methods.R
\name{wrap}
\alias{wrap}
\title{Wrap a simulation environment}
\usage{
wrap(.env)
}
\arguments{
\item{.env}{the simulation environment.}
}
\value{
Returns a simulation wrapper.
}
\description{
This function extracts the monitored data from a simulation environment
making it accessible through the same methods. Only useful if you want
to parallelize heavy replicas (see the example below), because the C++
simulation backend is destroyed when the threads exit.
}
\examples{
\dontrun{
library(parallel)

mm1 <- trajectory() \%>\%
  seize("server", 1) \%>\%
  timeout(function() rexp(1, 2)) \%>\%
  release("server", 1)

envs <- mclapply(1:4, function(i) {
  simmer("M/M/1 example") \%>\%
    add_resource("server", 1) \%>\%
    add_generator("customer", mm1, function() rexp(1, 1)) \%>\%
    run(100) \%>\%
    wrap()
})
}
}
\seealso{
Methods for dealing with a simulation wrapper:
\code{\link{get_mon_arrivals}}, \code{\link{get_mon_attributes}}, \code{\link{get_mon_resources}},
\code{\link{get_n_generated}}, \code{\link{get_capacity}}, \code{\link{get_queue_size}},
\code{\link{get_server_count}}, \code{\link{get_queue_count}}.
}
