% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer.R, R/simulator-methods.R
\docType{package}
\name{simmer}
\alias{simmer}
\alias{simmer-package}
\alias{simmer}
\title{\pkg{simmer}: Discrete-Event Simulation for \R}
\usage{
simmer(name = "anonymous", verbose = FALSE)
}
\arguments{
\item{name}{the name of the simulator.}

\item{verbose}{enable showing activity information.}
}
\value{
Returns a simulation environment.
}
\description{
A process-oriented and trajectory-based Discrete-Event Simulation (DES)
package for \R. Designed to be a generic framework like \pkg{SimPy} or
\pkg{SimJulia}, it leverages the power of \pkg{Rcpp} to boost the performance
and turning DES in \R feasible. As a noteworthy characteristic, \pkg{simmer}
exploits the concept of trajectory: a common path in the simulation model for
entities of the same type. It is pretty flexible and simple to use, and
leverages the chaining/piping workflow introduced by the \pkg{magrittr} package.

This method initialises a simulation environment.
}
\examples{
\dontrun{
# introduction to simmer
vignette("A-introduction")

# more vignettes
vignette(package = "simmer")
}

t0 <- trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)

env <- simmer("SuperDuperSim") \%>\%
  add_resource("nurse", 1) \%>\%
  add_resource("doctor", 2) \%>\%
  add_resource("administration", 1) \%>\%
  add_generator("patient", t0, function() rnorm(1, 10, 2)) \%>\%
  run(until=80)

}
\seealso{
\pkg{simmer}'s homepage \url{http://r-simmer.org} and
GitHub repository \url{https://github.com/r-simmer/simmer}.

Methods for dealing with a simulation environment:
\code{\link{reset}}, \code{\link{now}}, \code{\link{peek}}, \code{\link{onestep}}, \code{\link{run}},
\code{\link{add_resource}}, \code{\link{add_generator}}, \code{\link{get_mon_arrivals}},
\code{\link{get_mon_attributes}}, \code{\link{get_mon_resources}}, \code{\link{get_n_generated}},
\code{\link{get_capacity}}, \code{\link{get_queue_size}},
\code{\link{get_server_count}}, \code{\link{get_queue_count}}.
}
\author{
Iñaki Ucar and Bart Smeets
}
