% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_rejection.R
\name{calc_rejection}
\alias{calc_rejection}
\title{Calculate rejection rate and MCSE}
\usage{
calc_rejection(res_dat, p_values, alpha = 0.05)
}
\arguments{
\item{res_dat}{data frame or tibble containing the simulation results.}

\item{p_values}{name of the column containing the p-values.}

\item{alpha}{number indicating the nominal alpha level. Default value is set to the conventional .05.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate
and the associated MCSE.
}
\description{
Calculates rejection rate. The function also calculates the associated
Monte Carlo standard error.
}
\examples{
calc_rejection(res_dat = t_res, p_values = p_val)


}
