% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex_matrices.R
\name{as_incidence_complex}
\alias{as_incidence_complex}
\title{Complex Incidence Matrix}
\usage{
as_incidence_complex(g, attr)
}
\arguments{
\item{g}{igraph object.}

\item{attr}{edge attribute name that encodes positive ("P"), negative ("N") and ambivalent ("A") ties.}
}
\value{
a complex matrix
}
\description{
The complex incidence matrix of a signed graph containing ambivalent ties.
}
\details{
This function is slightly different than \link[igraph]{as_incidence_matrix} since it is defined for bipartite graphs.
The incidence matrix here is defined as a \eqn{S \in C^{n,m}}, where n is the number of vertices and m the number of edges. Edges (i,j) are oriented such that i<j and entries are defined as
\deqn{S_{i(i,j)}=\sqrt{A_{ij}}}
\deqn{S_{j(i,j)}=-\sqrt{A_{ji}} if (i,j) is an ambivalent tie}
\deqn{S_{j(i,j)}=-A_{ji}\sqrt{A_{ji}} else}
}
\seealso{
\link{laplacian_matrix_complex},\link{as_adj_complex}
}
\author{
David Schoch
}
