% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signed_triangles.R
\name{count_complex_triangles}
\alias{count_complex_triangles}
\title{count complex triangles}
\usage{
count_complex_triangles(g, attr)
}
\arguments{
\item{g}{igraph object.}

\item{attr}{edge attribute name that encodes positve ("P"), negative ("N") and ambivalent ("A") ties.}
}
\value{
counts for all complex triangle types
}
\description{
Counts the number of all possible signed triangles (+++),(++-), (+--) and (---)
}
\examples{
library(igraph)
g <- graph.full(4)
E(g)$type <- c("P","N","A","A","P","N")
count_complex_triangles(g,attr = "type")
}
\seealso{
\link{signed_triangles}
}
\author{
David Schoch
}
