% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_profile_loop.R
\name{show_sig_profile_loop}
\alias{show_sig_profile_loop}
\title{Show Signature Profile with Loop Way}
\usage{
show_sig_profile_loop(
  Signature,
  sig_names = NULL,
  ncol = 1,
  nrow = NULL,
  x_lab = "Components",
  ...
)
}
\arguments{
\item{Signature}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract},
or just a raw signature matrix with row representing components (motifs) and column
representing signatures (column names must start with 'Sig').}

\item{sig_names}{subset signatures or set name of signatures, can be a character vector.
Default is \code{NULL}, prefix 'Sig' plus number is used.}

\item{ncol}{(optional) Number of columns in the plot grid.}

\item{nrow}{(optional) Number of rows in the plot grid.}

\item{x_lab}{x axis lab.}

\item{...}{other parameters but \code{sig_order} passing to \link{show_sig_profile}.}
}
\value{
a \code{ggplot} result from \code{cowplot::plot_grid()}.
}
\description{
Show Signature Profile with Loop Way
}
\examples{

load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Show signature profile
p1 <- show_sig_profile_loop(sig2, mode = "SBS")
p1
p2 <- show_sig_profile_loop(sig2, mode = "SBS", style = "cosmic", sig_names = c("A", "B", "C"))
p2
}
\seealso{
\link{show_sig_profile}
}
