% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_estimate.R
\name{sig_estimate}
\alias{sig_estimate}
\title{Estimate Signature Number}
\usage{
sig_estimate(
  nmf_matrix,
  range = 2:5,
  nrun = 10,
  use_random = FALSE,
  method = "brunet",
  seed = 123456,
  cores = 1,
  keep_nmfObj = FALSE,
  save_plots = FALSE,
  plot_basename = file.path(tempdir(), "nmf"),
  what = "all",
  verbose = FALSE
)
}
\arguments{
\item{nmf_matrix}{a \code{matrix} used for NMF decomposition with rows indicate samples and columns indicate components.}

\item{range}{a \code{numeric} vector containing the ranks of factorization to try. Note that duplicates are removed
and values are sorted in increasing order. The results are notably returned in this order.}

\item{nrun}{a \code{numeric} giving the number of run to perform for each value in \code{range}, \code{nrun} set to 30~50 is
enough to achieve robust result.}

\item{use_random}{Should generate random data from input to test measurements. Default is \code{TRUE}.}

\item{method}{specification of the NMF algorithm. Use 'brunet' as default.
Available methods for NMF decompositions are 'brunet', 'lee', 'ls-nmf', 'nsNMF', 'offset'.}

\item{seed}{specification of the starting point or seeding method, which will compute a starting point,
usually using data from the target matrix in order to provide a good guess.}

\item{cores}{number of cpu cores to run NMF.}

\item{keep_nmfObj}{default is \code{FALSE}, if \code{TRUE}, keep NMF objects from runs, and the result may be huge.}

\item{save_plots}{if \code{TRUE}, save signature number survey plot to local machine.}

\item{plot_basename}{when save plots, set custom basename for file path.}

\item{what}{a character vector whose elements partially match one of the following item, which correspond to
the measures computed by summary on each multi-run NMF result: ‘all’, ‘cophenetic’, ‘rss’, ‘residuals’,
‘dispersion’, ‘evar’, ‘silhouette’ (and more specific .coef, .basis, .consensus), ‘sparseness’
(and more specific .coef, .basis). It specifies which measure must be plotted
(what='all' plots all the measures).}

\item{verbose}{if \code{TRUE}, print extra message.}
}
\value{
a \code{list} contains information of NMF run and rank survey.
}
\description{
Use \strong{NMF} package to evaluate the optimal number of signatures.
This is used along with \link{sig_extract}.
Users should \code{library(NMF)} firstly. If NMF objects are returned,
the result can be further visualized by NMF plot methods like
\code{NMF::consensusmap()} and \code{NMF::basismap()}.
}
\details{
The most common approach is to choose the smallest rank for which cophenetic correlation coefficient
starts decreasing (Used by this function). Another approach is to choose the rank for which the plot
of the residual sum of squares (RSS) between the input matrix and its estimate shows an inflection point.
More custom features please directly use \link[NMF:nmfEstimateRank]{NMF::nmfEstimateRank}.
}
\examples{
load(system.file("extdata", "toy_copynumber_tally_M.RData",
  package = "sigminer", mustWork = TRUE
))
\dontrun{
cn_estimate <- sig_estimate(cn_tally_M$nmf_matrix,
  cores = 1, nrun = 5,
  verbose = TRUE
)
}
}
\references{
Gaujoux, Renaud, and Cathal Seoighe. "A flexible R package for nonnegative matrix factorization." BMC bioinformatics 11.1 (2010): 367.
}
\seealso{
\link{sig_extract} for extracting signatures using \strong{NMF} package, \link{sig_auto_extract} for
extracting signatures using automatic relevance determination technique.
}
\author{
Shixiang Wang
}
