% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.shoreline_date}
\alias{print.shoreline_date}
\title{print.shoreline_date}
\usage{
\method{print}{shoreline_date}(x, ...)
}
\arguments{
\item{x}{Object of class \code{shoreline_date}.}

\item{...}{Additional arguments.}
}
\value{
Print the site names, elevations, non-default isobase directions and
HDRs contained in a \code{shoreline_date} object to console.
}
\description{
Print the dates in a \code{shoreline_date} object. Each date is printed
with site name, elevation and highest density region. If the isobase
direction is different or more are provided than the default, the
directions and dates associated with these are printed seperately.
}
\examples{
\dontrun{
target_point <- sf::st_sfc(sf::st_point(c(538310, 6544255)), crs = 32632)

target_date <- shoreline_date(site = target_point, elevation = 70)

# Print to console
target_date
}
}
