% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{snapshotCompare}
\alias{snapshotCompare}
\alias{snapshotUpdate}
\title{Compare current and expected snapshots}
\usage{
snapshotCompare(
  appDir,
  testnames = NULL,
  autoremove = TRUE,
  images = TRUE,
  quiet = FALSE,
  interactive = base::interactive(),
  suffix = NULL
)

snapshotUpdate(appDir = ".", testnames = NULL, quiet = FALSE, suffix = NULL)
}
\arguments{
\item{appDir}{Directory that holds the tests for an application. This is the
parent directory for the expected and current snapshot directories.}

\item{testnames}{Name or names of a test. If NULL, compare all test results.}

\item{autoremove}{If the current results match the expected results, should
the current results be removed automatically? Defaults to TRUE.}

\item{images}{Should screenshots and PNG images be compared? It can be useful
to set this to \code{FALSE} when the expected results were taken on a
different platform from the current results.}

\item{quiet}{Should output be suppressed? This is useful for automated
testing.}

\item{interactive}{If there are any differences between current results and
expected results, provide an interactive graphical viewer that shows the
changes and allows the user to accept or reject the changes.}

\item{suffix}{An optional suffix for the expected results directory. For
example, if the suffix is \code{"mac"}, the expected directory would be
\code{mytest-expected-mac}.}
}
\description{
This compares current and expected snapshots for a test set, and prints any
differences to the console.
}
\seealso{
\code{\link{testApp}}
}
