% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{Interactions}
\alias{Interactions}
\alias{jqui_draggable}
\alias{jqui_droppable}
\alias{jqui_resizable}
\alias{jqui_selectable}
\alias{jqui_sortable}
\title{Mouse interactions}
\usage{
jqui_draggable(
  ui,
  operation = c("enable", "disable", "destroy", "save", "load"),
  options = NULL
)

jqui_droppable(
  ui,
  operation = c("enable", "disable", "destroy", "save", "load"),
  options = NULL
)

jqui_resizable(
  ui,
  operation = c("enable", "disable", "destroy", "save", "load"),
  options = NULL
)

jqui_selectable(
  ui,
  operation = c("enable", "disable", "destroy", "save", "load"),
  options = NULL
)

jqui_sortable(
  ui,
  operation = c("enable", "disable", "destroy", "save", "load"),
  options = NULL
)
}
\arguments{
\item{ui}{The target ui element(s) to be manipulated. Can be
\itemize{
\item A \code{shiny.tag}
or \code{shiny.tag.list} object
\item A static \code{htmlwidget} object
\item A string of
\href{https://api.jquery.com/category/selectors/}{jQuery_selector}
\item A
\link[htmlwidgets:JS]{JS()} wrapped javascript expression that returns a
\href{https://api.jquery.com/Types/}{jQuery object}.
}}

\item{operation}{A string to determine how to manipulate the mouse
interaction. Can be one of \code{enable}, \code{disable}, \code{destroy}, \code{save} and
\code{load}. Ignored when \code{ui} is a \code{shiny.tag} or \code{shiny.tag.list} object. See
Details.}

\item{options}{A list of
\href{https://api.jqueryui.com/category/interactions/}{interaction_specific_options}.
Ignored when \code{operation} is set as \code{destroy}. This parameter also accept a
\code{shiny} option that controls the shiny input value returned from the
element. See Details.}
}
\value{
The same object passed in the \code{ui} parameter
}
\description{
Attach mouse-based interactions to shiny html tags, shiny input/output
widgets or static htmlwidgets and provide ways to manipulate them. The
interactions include:
\itemize{
\item \href{https://api.jqueryui.com/draggable/}{draggable}:
Allow elements to be moved using the mouse.
\item \href{https://api.jqueryui.com/droppable/}{droppable}: Create targets for draggable
elements.
\item \href{https://api.jqueryui.com/resizable/}{resizable}: Change the size
of an element using the mouse.
\item \href{https://api.jqueryui.com/selectable/}{selectable}: Use the mouse to select
elements, individually or in a group.
\item \href{https://api.jqueryui.com/sortable/}{sortable}: Reorder elements in a list or
grid using the mouse.
}
}
\details{
The first parameter \code{ui} determines the target ui and working mode. If the
target ui is a \code{shiny.tag} (e.g., shiny inputs/outputs or ui created by
\link[htmltools:builder]{tags}) or a \code{shiny.tag.list} (by \link[shiny:reexports]{tagList()}) object
or a static \code{htmlwidget}, the functions return the a modified ui object with
interaction effects attached. When a
\href{https://api.jquery.com/category/selectors/}{jQuery_selector} or a javascript
expression is provided as the \code{ui} parameter, the functions first use it to
locate the target ui element(s) in shiny app, and then attach or manipulate
the interactions. Therefore, you can use the first way  in \code{ui} of a shiny
app to created elements with interaction effects (the ui mode), or use the
second way  in \code{server} to manipulate the interactions (the server mode).

The \code{operation} parameter is valid only in server mode. It determines how to
manipulate the interaction, which includes:
\itemize{
\item \code{enable}: Attach the
corresponding mouse interaction to the target(s).
\item \code{disable}: Attach the
interaction if not and disable it at once (only set the options).
\item \code{destroy}: Destroy the interaction.
\item \code{save}: Attach the interaction if not
and save the current interaction state.
\item \code{load}: Attach the interaction if not and
restore the target(s) to the last saved interaction state.
}

With mouse interactions attached, the corresponding interaction states, e.g.
\code{position} of draggable, \code{size} of resizable, \code{selected} of selectable and
\code{order} of sortable, will be send to server side in the form of
\verb{input$<id>_<state>}. The default values can be overridden by setting the
\code{shiny} option in the \code{options} parameter. Please see the vignette
\verb{Introduction to shinyjqui} for more details.
}
\examples{
library(shiny)
library(highcharter)

## used in ui
jqui_resizable(actionButton('btn', 'Button'))
jqui_draggable(plotOutput('plot', width = '400px', height = '400px'),
                options = list(axis = 'x'))
jqui_selectable(
  div(
    id = 'sel_plots',
    highchartOutput('highchart', width = '300px'),
    plotOutput('ggplot', width = '300px')
  ),
  options = list(
    classes = list(`ui-selected` = 'ui-state-highlight')
  )
)
jqui_sortable(tags$ul(
  id = 'lst',
  tags$li('A'),
  tags$li('B'),
  tags$li('C')
))

## used in server
\dontrun{
  jqui_draggable('#foo', options = list(grid = c(80, 80)))
  jqui_droppable('.foo', operation = "enable")
}

## use shiny input
if (interactive()) {
  shinyApp(
    server = function(input, output) {
      output$foo <- renderHighchart({
        hchart(mtcars, "scatter", hcaes(x = cyl, y = mpg))
      })
      output$position <- renderPrint({
        print(input$foo_position)
      })
    },
    ui = fluidPage(
      verbatimTextOutput('position'),
      jqui_draggable(highchartOutput('foo', width = '200px', height = '200px'))
    )
  )
}

## custom shiny input
func <- JS('function(event, ui){return $(event.target).offset();}')
options <-  list(
  shiny = list(
    abs_position = list(
      dragcreate = func, # send returned value back to shiny when interaction is created.
      drag = func # send returned value to shiny when dragging.
    )
  )
)
jqui_draggable(highchartOutput('foo', width = '200px', height = '200px'),
                options = options)


}
