% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-circlebutton.R
\name{circleButton}
\alias{circleButton}
\title{Circle Action button}
\usage{
circleButton(inputId, icon = NULL, status = "default", size = "default", ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{icon}{An icon to appear on the button.}

\item{status}{Color of the button.}

\item{size}{Size of the button : default, lg, sm, xs.}

\item{...}{Named attributes to be applied to the button.}
}
\description{
Create a rounded action button.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    tags$h3("Rounded actionBution"),
    circleButton(inputId = "btn1", icon = icon("cog")),
    circleButton(
      inputId = "btn2",
      icon = icon("sliders"),
      status = "primary"
    ),
    verbatimTextOutput("res1"),
    verbatimTextOutput("res2")
  )

  server <- function(input, output, session) {

    output$res1 <- renderPrint({
      paste("value button 1:", input$btn1)
    })
    output$res2 <- renderPrint({
      paste("value button 2:", input$btn2)
    })

  }

  shinyApp(ui, server)
}
}
