% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-knob.R
\name{knobInput}
\alias{knobInput}
\title{Knob Input}
\usage{
knobInput(
  inputId,
  label,
  value,
  min = 0,
  max = 100,
  step = 1,
  angleOffset = 0,
  angleArc = 360,
  cursor = FALSE,
  thickness = NULL,
  lineCap = c("default", "round"),
  displayInput = TRUE,
  displayPrevious = FALSE,
  rotation = c("clockwise", "anticlockwise"),
  fgColor = NULL,
  inputColor = NULL,
  bgColor = NULL,
  pre = NULL,
  post = NULL,
  fontSize = NULL,
  readOnly = FALSE,
  skin = NULL,
  width = NULL,
  height = NULL,
  immediate = TRUE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value.}

\item{min}{Minimum allowed value, default to \code{0}.}

\item{max}{Maximum allowed value, default to \code{100}.}

\item{step}{Specifies the interval between each selectable value, default to \code{1}.}

\item{angleOffset}{Starting angle in degrees, default to \code{0}.}

\item{angleArc}{Arc size in degrees, default to \code{360}.}

\item{cursor}{Display mode "cursor", don't work properly if \code{width} is not set in pixel, (\code{TRUE} or \code{FALSE}).}

\item{thickness}{Gauge thickness, numeric value.}

\item{lineCap}{Gauge stroke endings, 'default' or 'round'.}

\item{displayInput}{Hide input in the middle of the knob (\code{TRUE} or \code{FALSE}).}

\item{displayPrevious}{Display the previous value with transparency (\code{TRUE} or \code{FALSE}).}

\item{rotation}{Direction of progression, 'clockwise' or 'anticlockwise'.}

\item{fgColor}{Foreground color.}

\item{inputColor}{Input value (number) color.}

\item{bgColor}{Background color.}

\item{pre}{A prefix string to put in front of the value.}

\item{post}{A suffix string to put after the value.}

\item{fontSize}{Font size, must be a valid CSS unit.}

\item{readOnly}{Disable knob (\code{TRUE} or \code{FALSE}).}

\item{skin}{Change Knob skin, only one option available : 'tron'.}

\item{width, height}{The width and height of the input, e.g. \code{400px}, or \code{100\%}.
A value a pixel is recommended, otherwise the knob won't be able to initialize itself in some case
(if hidden at start for example).}

\item{immediate}{If \code{TRUE} (default), server-side value is updated each time value change,
if \code{FALSE} value is updated when user release the widget.}
}
\value{
Numeric value server-side.
}
\description{
Knob Input
}
\examples{
if (interactive()) {

library("shiny")
library("shinyWidgets")

ui <- fluidPage(
  knobInput(
    inputId = "myKnob",
    label = "Display previous:",
    value = 50,
    min = -100,
    displayPrevious = TRUE,
    fgColor = "#428BCA",
    inputColor = "#428BCA"
  ),
  verbatimTextOutput(outputId = "res")
)

server <- function(input, output, session) {

  output$res <- renderPrint(input$myKnob)

}

shinyApp(ui = ui, server = server)

}
}
\seealso{
\code{\link{updateKnobInput}} for updating the value server-side.
}
