% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-pretty.R
\name{updatePrettyRadioButtons}
\alias{updatePrettyRadioButtons}
\title{Change the value pretty radio buttons on the client}
\usage{
updatePrettyRadioButtons(session, inputId, label = NULL, choices = NULL,
  selected = NULL, inline = FALSE, choiceNames = NULL,
  choiceValues = NULL, prettyOptions = list())
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{choices}{The choices to set for the input object, updating choices will reset
parameters like \code{status}, \code{shape}, ... on the radion buttons, you can re-specify
(or change them) in argument \code{prettyOptions}.}

\item{selected}{The value to set for the input object.}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally).}

\item{choiceNames}{The choices names to set for the input object.}

\item{choiceValues}{The choices values to set for the input object.}

\item{prettyOptions}{Arguments passed to \code{\link{prettyRadioButtons}} for styling radio buttons}
}
\description{
Change the value pretty radio buttons on the client
}
\examples{
\dontrun{

 if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h1("Update pretty radio buttons"),
  br(),

  fluidRow(
    column(
      width = 6,
      prettyRadioButtons(inputId = "radio1",
                          label = "Update my value!",
                          choices = month.name[1:4],
                          status = "danger",
                          icon = icon("remove")),
      verbatimTextOutput(outputId = "res1"),
      br(),
      radioButtons(
        inputId = "update1", label = "Update value :",
        choices = month.name[1:4], inline = TRUE
      )
    ),
    column(
      width = 6,
      prettyRadioButtons(inputId = "radio2",
                          label = "Update my choices!", thick = TRUE,
                          choices = month.name[1:4],
                          animation = "pulse", status = "info"),
      verbatimTextOutput(outputId = "res2"),
      br(),
      actionButton(inputId = "update2", label = "Update choices !")
    )
  )

)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$radio1)

  observeEvent(input$update1, {
    updatePrettyRadioButtons(
      session = session,
      inputId = "radio1",
      selected = input$update1
    )
  }, ignoreNULL = FALSE)

  output$res2 <- renderPrint(input$radio2)
  observeEvent(input$update2, {
    updatePrettyRadioButtons(
      session = session, inputId = "radio2",
      choices = sample(month.name, 4),
      prettyOptions = list(animation = "pulse",
                           status = "info",
                           shape = "round")
    )
  }, ignoreInit = TRUE)

}

shinyApp(ui, server)

 }

}
}
