% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setShake.R
\name{setShake}
\alias{setShake}
\title{Custom shake animation}
\usage{
setShake(id = NULL, class = NULL, duration = 0.82)
}
\arguments{
\item{id}{Use this argument if you want to target an individual element.}

\item{class}{The element to which the shake should be applied.
For example, class is set to box.}

\item{duration}{Shake total duration. 0.82s by default.}
}
\description{
Allow to apply a shake animation on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyEffects)

  boxTag <- boxPlus(
   title = "Closable box, with label",
   closable = TRUE,
   enable_label = TRUE,
   label_text = 1,
   label_status = "danger",
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPagePlus(
     header = dashboardHeaderPlus(
       enable_rightsidebar = TRUE,
       rightSidebarIcon = "gears"
     ),
     sidebar = dashboardSidebar(),
     body = dashboardBody(

      setShake(class = "box"),
      setShake(id = "my-progress"),

      tags$h2("Add shake to the box class"),
      fluidRow(boxTag, boxTag),
      tags$h2("Add shake only to the first element using id"),
      tagAppendAttributes(
       verticalProgress(
        value = 10,
        striped = TRUE,
        active = TRUE
       ),
       id = "my-progress"
      ),
      verticalProgress(
        value = 50,
        active = TRUE,
        status = "warning",
        size = "xs"
      ),
      verticalProgress(
        value = 20,
        status = "danger",
        size = "sm",
        height = "60\%"
      )
     ),
     rightsidebar = rightSidebar(),
     title = "Shake Effect"
   ),
   server = function(input, output) { }
  )
}
}
