% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renders.R
\name{.cb_input}
\alias{.cb_input}
\title{Create input controller insensitive to server updates}
\usage{
.cb_input(ui, data_param, ..., priority = NULL)
}
\arguments{
\item{ui}{UI defining input controllers.}

\item{data_param}{Name of the parameter that should be updated in filter whenever user change the input value.}

\item{...}{Extra attributes passed to the input div container.}

\item{priority}{Set to 'event' to force sending value.}
}
\value{
A `shiny.tag` object defining html structure of filter input container.
}
\description{
Input controllers created with `.cb_input` are sending its value to server only when
user changes it's value directly in browser.
That means all the `update*` functions have only visible effect on application output.

The method should be used for each filter input controller and precise which
filter value should be updated when the input selection is changes.
}
\examples{

if (interactive()) {
  library(shiny)
  library(shinyCohortBuilder)

  shiny::addResourcePath(
    "shinyCohortBuilder",
    system.file("www", package = "shinyCohortBuilder")
  )
  ui <- fluidPage(
    tags$head(
      shiny::tags$script(type = "text/javascript", src = file.path("shinyCohortBuilder", "scb.js"))
    ),
    actionButton("update", "Update with random value"),
    div(
      class = "cb_container",
      `data-ns_prefix` = "",
      div(
        class = "cb_step",
        `data-step_id` = "1",
        div(
          class = "cb_filter",
          `data-filter_id` = "filid",
          .cb_input(
            numericInput("val", "Value", value = 1),
            data_param = "range"
          )
        )
      )
    )
  )

  server <- function(input, output, session) {
    observeEvent(input$action, {
      # print should be avoided when value is changed due to update
      print(input$action)
    })
    observeEvent(input$update, {
      updateNumericInput(session, "val", value = rnorm(1))
    })
  }

  shinyApp(ui, server)
}
}
