% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shinywrappers.R
\name{renderDataTable}
\alias{renderDataTable}
\title{Table output with the JavaScript library DataTables}
\usage{
renderDataTable(expr, options = NULL, searchDelay = 500,
  callback = "function(oTable) {}", escape = TRUE, env = parent.frame(),
  quoted = FALSE)
}
\arguments{
\item{expr}{An expression that returns a data frame or a matrix.}

\item{options}{A list of initialization options to be passed to DataTables,
or a function to return such a list.}

\item{searchDelay}{The delay for searching, in milliseconds (to avoid too
frequent search requests).}

\item{callback}{A JavaScript function to be applied to the DataTable object.
This is useful for DataTables plug-ins, which often require the DataTable
instance to be available (\url{http://datatables.net/extensions/}).}

\item{escape}{Whether to escape HTML entities in the table: \code{TRUE} means
to escape the whole table, and \code{FALSE} means not to escape it.
Alternatively, you can specify numeric column indices or column names to
indicate which columns to escape, e.g. \code{1:5} (the first 5 columns),
\code{c(1, 3, 4)}, or \code{c(-1, -3)} (all columns except the first and
third), or \code{c('Species', 'Sepal.Length')}.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Makes a reactive version of the given function that returns a data frame (or
matrix), which will be rendered with the DataTables library. Paging,
searching, filtering, and sorting can be done on the R side using Shiny as
the server infrastructure.
}
\details{
For the \code{options} argument, the character elements that have the class
\code{"AsIs"} (usually returned from \code{\link{I}()}) will be evaluated in
JavaScript. This is useful when the type of the option value is not supported
in JSON, e.g., a JavaScript function, which can be obtained by evaluating a
character string. Note this only applies to the root-level elements of the
options list, and the \code{I()} notation does not work for lower-level
elements in the list.
}
\note{
This function only provides the server-side version of DataTables
  (using R to process the data object on the server side). There is a
  separate package \pkg{DT} (\url{https://github.com/rstudio/DT}) that allows
  you to create both server-side and client-side DataTables. The functions
  \code{renderDataTable()} and \code{dataTableOutput()} in \pkg{shiny} have
  been deprecated since v0.11.1. Please use \code{DT::renderDataTable()} and
  \code{DT::dataTableOutput()} (see
  \url{http://rstudio.github.io/DT/shiny.html} for more information).
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  # pass a callback function to DataTables using I()
  shinyApp(
    ui = fluidPage(
      fluidRow(
        column(12,
          dataTableOutput('table')
        )
      )
    ),
    server = function(input, output) {
      output$table <- renderDataTable(iris,
        options = list(
          pageLength = 5,
          initComplete = I("function(settings, json) {alert('Done.');}")
        )
      )
    }
  )
}
}
\references{
\url{http://datatables.net}
}

