% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-storage-postgresql.R
\name{DataStoragePostgreSQL}
\alias{DataStoragePostgreSQL}
\title{Data storage class with PostgreSQL provider}
\description{
Implementation of the \code{\link{DataStorage}} R6 class to PostgreSQL backend using a
unified API for read/write operations
}
\examples{
\dontrun{
data_storage <- DataStoragePostgreSQL$new(user = "postgres", password = "mysecretpassword")

data_storage$insert("example", "test_event", "session1")
data_storage$insert("example", "input", "s1", list(id = "id1"))
data_storage$insert("example", "input", "s1", list(id = "id2", value = 32))

data_storage$insert(
  "example", "test_event_3_days_ago", "session1",
  time = lubridate::as_datetime(lubridate::today() - 3)
)

data_storage$read_event_data()
data_storage$read_event_data(Sys.Date() - 1, Sys.Date() + 1)
data_storage$close()
}
}
\section{Super classes}{
\code{\link[shiny.telemetry:DataStorage]{shiny.telemetry::DataStorage}} -> \code{\link[shiny.telemetry:DataStorageSQLFamily]{shiny.telemetry::DataStorageSQLFamily}} -> \code{DataStoragePostgreSQL}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStoragePostgreSQL-new}{\code{DataStoragePostgreSQL$new()}}
\item \href{#method-DataStoragePostgreSQL-clone}{\code{DataStoragePostgreSQL$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="close"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-close'><code>shiny.telemetry::DataStorage$close()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="insert"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-insert'><code>shiny.telemetry::DataStorage$insert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="read_event_data"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-read_event_data'><code>shiny.telemetry::DataStorage$read_event_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStoragePostgreSQL-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStoragePostgreSQL-new}{}}}
\subsection{Method \code{new()}}{
Initialize the data storage class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStoragePostgreSQL$new(
  username = NULL,
  password = NULL,
  hostname = "127.0.0.1",
  port = 5432,
  dbname = "shiny_telemetry",
  driver = "RPostgreSQL"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{username}}{string with a PostgreSQL username.}

\item{\code{password}}{string with the password for the username.}

\item{\code{hostname}}{string with hostname of PostgreSQL instance.}

\item{\code{port}}{numeric value with the port number of PostgreSQL instance.}

\item{\code{dbname}}{string with the name of the database in the PostgreSQL instance.}

\item{\code{driver}}{string, to select PostgreSQL driver among \code{c("RPostgreSQL", "RPostgres")}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStoragePostgreSQL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStoragePostgreSQL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStoragePostgreSQL$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
