% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeomorphCrossSection.R
\name{plotGeomorphCrossSection}
\alias{plotGeomorphCrossSection}
\title{Present a \code{SoilProfileCollection} aligned to a geomorphic summary as cross-section.}
\usage{
plotGeomorphCrossSection(
  x,
  type = c("line", "bar"),
  g = "hillpos",
  clust = TRUE,
  col = c("#377EB8", "#4DAF4A", "#984EA3", "#FF7F00", "#E41A1C"),
  ...
)
}
\arguments{
\item{x}{resulting list from \code{soilDB::fetchOSD(..., extended = TRUE)}}

\item{type}{character, 'line' for line plot or 'bar' for barplot of geomorphic proportions}

\item{g}{character, select a geomorphic summary. Currently 'hillpos' (2D hillslope position) is the only supported choice.}

\item{clust}{logical, use clustering order of geomorphic proportions or exact hydrologic ordering, see \code{\link[=hydOrder]{hydOrder()}}}

\item{col}{character vector of colors}

\item{\dots}{additional arguments to \code{\link[=iterateHydOrder]{iterateHydOrder()}}}
}
\description{
Present a \code{SoilProfileCollection} aligned to a geomorphic summary as cross-section.
}
\author{
D.E. Beaudette
}
