% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_algorithms.R
\name{SparseKMeansClustering}
\alias{SparseKMeansClustering}
\title{Sparse K means clustering}
\usage{
SparseKMeansClustering(xdata, nc = NULL, Lambda, ...)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, tau*nrow(xdata))}.}

\item{Lambda}{vector of penalty parameters (see argument \code{wbounds} in
\code{\link[sparcl]{KMeansSparseCluster}}).}

\item{...}{additional parameters passed to
\code{\link[sparcl]{KMeansSparseCluster}}.}
}
\value{
A list with: \item{comembership}{an array of binary and symmetric
  co-membership matrices.} \item{weights}{a matrix of median weights by
  feature.}
}
\description{
Runs sparse K means clustering using implementation from
\code{\link[sparcl]{KMeansSparseCluster}}. This function is not using
stability.
}
\references{
\insertRef{SparseClustering}{sharp}
}
\keyword{internal}
