% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rd_ras.R
\name{plot.rd_ras}
\alias{plot.rd_ras}
\title{plot.rd_ras}
\usage{
\method{plot}{rd_ras}(x, n = NULL, col, verbose = TRUE, nrow, ncol, ...)
}
\arguments{
\item{x}{rd_ras object with randomized raster.}

\item{n}{Integer with number or vector of ids of randomized raster to plot.
See Details section for more information.}

\item{col}{Vector with color palette used for plotting.}

\item{verbose}{Logical if messages are printed.}

\item{nrow, ncol}{Integer with number of rows and columns of plot grid.}

\item{...}{Not used.}
}
\value{
void
}
\description{
Plot method for rd_ras object
}
\details{
Function to plot randomized raster. If \code{n} is a single number, \code{n} randomized
raster will be sampled to plot. If \code{n} is a vector, the corresponding raster
will be plotted. \code{col, nrow, ncol} are passed to \code{plot}.
}
\examples{
\dontrun{
landscape_classified <- classify_habitats(landscape, n = 5, style = "fisher")
landscape_random <- randomize_raster(landscape_classified, n_random = 19)
plot(landscape_random)
}

}
\seealso{
\code{\link{randomize_raster}} \cr
\code{\link{translate_raster}}
}
