% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pcf_fast.R
\name{estimate_pcf_fast}
\alias{estimate_pcf_fast}
\title{estimate_pcf_fast}
\usage{
estimate_pcf_fast(pattern, ...)
}
\arguments{
\item{pattern}{Point pattern.}

\item{...}{Arguments passed down to `Kest` or `pcf.fv`.}
}
\value{
fv.object
}
\description{
Fast estimation of the pair correlation function
}
\details{
The functions estimates the pair correlation functions based on an estimation
of Ripley's K-function. This makes it computationally faster than estimating the
pair correlation function directly. It is a wrapper around `Kest` and `pcf.fv`.
}
\examples{
pcf_species_b <- estimate_pcf_fast(species_a)

}
\references{
Ripley, B.D. (1977) Modelling spatial patterns (with discussion). Journal of
the Royal Statistical Society, Series B, 39, 172-212.

Stoyan, D, Kendall, W.S. and Mecke, J. (1995) Stochastic geometry and its
applications. 2nd edition. Springer Verlag.

Stoyan, D. and Stoyan, H. (1994) Fractals, random shapes and point fields:
methods of geometrical statistics. John Wiley and Sons.
}
\seealso{
\code{\link{Kest}} \cr
\code{\link{pcf.fv}}
}
