% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapviz_methods.R
\name{print.shapviz}
\alias{print.shapviz}
\title{Prints "shapviz" Object}
\usage{
\method{print}{shapviz}(x, n = 2L, ...)
}
\arguments{
\item{x}{An object of class "shapviz".}

\item{n}{Maximum number of rows of SHAP values and feature values to show.}

\item{...}{Further arguments passed from other methods.}
}
\value{
Invisibly, the input is returned.
}
\description{
Prints "shapviz" Object
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
shapviz(S, X, baseline = 4)
}
\seealso{
\code{\link{shapviz}}.
}
