% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_check_cuda}
\alias{vaeac_check_cuda}
\title{Function that checks for access to CUDA}
\usage{
vaeac_check_cuda(cuda, verbose)
}
\arguments{
\item{cuda}{Logical (default is \code{FALSE}). If \code{TRUE}, then the \code{vaeac} model will be trained using cuda/GPU.
If \code{\link[torch:cuda_is_available]{torch::cuda_is_available()}} is \code{FALSE}, we fall back to using the CPU. Using a GPU
for smaller tabular dataset often do not improve the efficiency.
See \code{vignette("installation", package = "torch")} fo help to enable running on the GPU (only Linux and Windows).}

\item{verbose}{String vector or NULL.
Controls verbosity (printout detail level) via one or more of \code{"basic"}, \code{"progress"},
\code{"convergence"}, \code{"shapley"} and \code{"vS_details"}.
\code{"basic"} (default) displays basic information about the computation and messages about parameters/checks.
\code{"progress"} displays where in the calculation process the function currently is.
\code{"convergence"} displays how close the Shapley value estimates are to convergence
(only when \code{iterative = TRUE}).
\code{"shapley"} displays intermediate Shapley value estimates and standard deviations (only when \code{iterative = TRUE}),
and the final estimates.
\code{"vS_details"} displays information about the v(S) estimates,
most relevant for \code{approach \%in\% c("regression_separate", "regression_surrogate", "vaeac")}.
\code{NULL} means no printout.
Any combination can be used, e.g., \code{verbose = c("basic", "vS_details")}.}
}
\value{
The function does not return anything.
}
\description{
Function that checks for access to CUDA
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
