% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shapeR.R
\name{getMeasurements}
\alias{getMeasurements}
\title{Get simple shape variables, filtered according to filter}
\usage{
getMeasurements(object)
}
\arguments{
\item{object}{\code{\linkS4class{shapeR}} object}
}
\value{
A data frame with all valid fish as determined by the slot \code{filter} and with columns:
\itemize{
  \item otolith.area
  \item otolith.length
  \item otolith.width
  \item otolith.perimeter
}
}
\description{
Returns shape variables length, width, perimeter and area determined in \code{\link{generateShapeCoefficients}}.
Returns only values as set in the slot \code{filter}.
These variables can only be obtained if the calibration measurements in pixels have been registered in the csv data file in a column labelled 'cal' (see example data file). To get the calibration measurements, use a image manipulation program and measure 1mm on the calibration measurement stick (that was taken for that particular dataset) and register how many pixels 1mm is into the column 'cal'.
}
\examples{
data(shape)
# Calculate the mean otolith area for each fish population
# The results are in square mm since the calibration ('cal') column
# in the data file is in pixels (1 mm/pixel).
tapply(getMeasurements(shape)$otolith.area, getMasterlist(shape)$pop,mean)
}
\author{
Lisa Anne Libungan
}

