% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shallot.R
\name{pairwise.probabilities}
\alias{pairwise.probabilities}
\alias{print.shallot.pairwiseProbability}
\alias{as.matrix.shallot.pairwiseProbability}
\title{Pairwise Probabilities}
\usage{
pairwise.probabilities(x, parallel = TRUE)
}
\arguments{
\item{x}{An object of class \code{shallot.samples.raw} when supplied to
\code{\link{pairwise.probabilities}} or an object of class
\code{shallot.pairwiseProbability} when supplied to \code{\link{print}} and
\code{\link{as.matrix}}.}

\item{parallel}{Should all of the CPU cores should be used?  Defaults to
\code{TRUE}.}
}
\value{
The \code{\link{pairwise.probabilities}} function returns an object
of class \code{shallot.pairwiseProbability}.

The \code{\link[=as.matrix.shallot.pairwiseProbability]{as.matrix}} function
returns a square matrix.
}
\description{
These functions relate to the pairwise probabilities that two items are
clustered together, i.e., belong to the same subset in a partition.
}
\details{
\code{\link{pairwise.probabilities}} calculates the pairwise probabilities
that two items are clustered together, i.e., belong to the same subset in a
partition.

\code{\link[=as.matrix.shallot.pairwiseProbability]{as.matrix}} converts the
results of \code{\link{pairwise.probabilities}} to an matrix.
}
\examples{

\dontrun{
example(shallot)
}

}
\seealso{
\code{\link{sample.partitions}}, \code{\link{process.samples}},
\code{\link{estimate.partition}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
