\name{spacecloud}
\title{Variogram Cloud}
\usage{spacecloud(point.obj, pair.obj, a1, a2, type='r', query.a, ...)}
\alias{spacecloud}
\arguments{
\item{point.obj}{a point object generated by \code{point()}}
\item{pair.obj}{a pair object generated by \code{pair()}}
\item{a1}{a variable to plot}
\item{a2}{an optional variable name, if entered the plot will be created between \code{a1} and \code{a2}}
\item{type}{either \code{'r'} for square-root differences or \code{'s'} for squared differences}
\item{query.a}{an optional variable name, if entered, the value of the variable will be displayed on the graphics device for points
identified by the user.}
\item{...}{additional arguments for \code{plot}}
}
\value{NULL}
\description{Create a scatter plot of square-root or squared differences between variable values at pairs of points versus the distance
between the points. }
\note{When \code{query.a} is entered, the user will be prompted to identify points on the display device. Because each point in the
plot represents a pair of locations, the user must identify each point twice, once for the "from" point and once for the "to"
point. Querying is ended by pressing the middle mouse button on the mouse while the cursor is in the display window. }
\seealso{\code{\link{point}}, \code{\link{pair}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.pair"))==0){example(pair)}
}
opar <- par(ask = interactive() && .Device == "X11")
spacecloud(maas.point,maas.pair,'zinc')
# identify some points:
spacecloud(maas.point,maas.pair,'zinc',query.a='zinc')
par(opar)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
\keyword{spatial}
