% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sgee.R
\name{plot.sgee}
\alias{plot.sgee}
\alias{plot.sgeeSummary}
\title{Coefficient Traceplot Function}
\usage{
\method{plot}{sgee}(x, y, penaltyFun = NULL, main = NULL,
  xlab = "Iterations", ylab = expression(beta), dropIntercept = FALSE,
  trueBeta = NULL, color = TRUE, manualLineColors = NULL,
  pointSpacing = 3, cutOff = NULL, ...)

\method{plot}{sgeeSummary}(x, y, ...)
}
\arguments{
\item{x}{Path of coefficient Estimates.}

\item{y}{Optional parameter inherited from \code{plot(x,y,...)}; not used
with sgee.}

\item{penaltyFun}{Optional function that when provided results ina plot
of the coefficient estimates verus the corresponding penalty value.
When no \code{penaltyFun} value is given,
the plot generated is of the coefficent
estimates versus the iteration number.}

\item{main}{Optional title of plot.}

\item{xlab}{Label of x axis; default value is 'Iterations'.}

\item{ylab}{Label of y axis; default value is the beta symbol.}

\item{dropIntercept}{Logical parameter indicating whether the intercept
estimates should be dropped from the plot (i.e. not plotted). The default is
FALSE.}

\item{trueBeta}{The true coefficient values. If the true coefficient
values can be provided, then coefficient estimates that are false positive
identifications as non-zero are marked in the plot.}

\item{color}{Logical parameter indicating that a plot using colors
to differentiate coefficients is desired.}

\item{manualLineColors}{Vector of desired line colors; must match dimension
of line colors needed (i.e. same number of colors as there are groups if
grouped covariates are sharing a color).}

\item{pointSpacing}{Space between marks used to indicate a coefficient
is a false positive. Spacing is measured in terms of number of indices
of the path matrix between marks.}

\item{cutOff}{Integer value indicating that only the first \code{cutOff}
steps are to be plotted. Default value is \code{NULL}, indicating all
steps are to be plotted.}

\item{...}{Not currently used.}
}
\description{
Function to produce the coefficent traceplot, with capabilities to
account for covariate groups. Used in place of the \code{plot} function.
}
\details{
plot.sgee is meant to allow for easy visualization of paths of stagewise
(or regularized) coefficient estimates. A great deal of flexibility is
provided in terms of how the plot is presented. The poenaltyFun paramter
allows for a penalty function to be provided (such as the $L_1$ norm)
to plot the coefficietn estimates against. 
When given the trueBeta parameter, the plot marks the paths of coefficient
estimates that are falsely identified as being non zero. Finally, a switch
for black and white versus color plots is provided (\code{color}).
}
\note{
Function is intended to give a visual representation of the
coefficient estimates. Which x values to compare the estimates to can
depend on the situation, but typically the most versatile measure
to use is the sum of absolute values, the $L_1$ norm; especially when
comparing different coefficient paths from different techniques.
}
\examples{


#####################
## Generate test data
#####################

## Initialize covariate values
p <- 50 
beta <- c(rep(2.4,5),
          c(1.3, 0, 1.7, 0, .5),
          rep(0.5,5),
          rep(0,p-15))
groupSize <- 1
numGroups <- length(beta)/groupSize



generatedData <- genData(numClusters = 50,
                         clusterSize = 4,
                         clusterRho = 0.6,
                         clusterCorstr = "exchangeable",
                         yVariance = 1,
                         xVariance = 1,
                         numGroups = numGroups,
                         groupSize = groupSize,
                         groupRho = 0.3,
                         beta = beta,
                         family = gaussian(),
                         intercept = 0)

genDF <- data.frame(generatedData$y, generatedData$x)
coefMat <- bisee(formula(genDF),
                 data = genDF,
                 lambda1 = 0,         ##effectively see
                 lambda2 = 1,
                 family = gaussian(),
                 clusterID = generatedData$clusterID, 
                 corstr="exchangeable", 
                 maxIt = 200,
                 epsilon = .1)
############################
## Various options for plots
############################

par(mfrow = c(2,2))

## plain useage
plot(coefMat, main = "Plain Usage")

## With penalty
plot(coefMat, penaltyFun = function(x){sum(abs(x))}, xlab
= expression(abs(abs(beta))[1]), main = "With Penalty")

## using true beta value to highlight misclassifications
plot(coefMat, trueBeta = beta, main = "ID Missclassification")

## black and white option
plot(coefMat, trueBeta = beta, color = FALSE, main =
"Black and White", pointSpacing = 5)



}
\author{
Gregory Vaughan
}
