### --> these are from ~/R/MM/GRAPHICS/axis-prettylab.R

### Help files: ../man/pretty10exp.Rd  ../man/axTexpr.Rd   ../man/eaxis.Rd
###                    --------------         ----------          --------

pretty10exp <- function(x, drop.1 = FALSE, digits.fuzz = 7)
{
    ## Purpose: produce "a 10^k"  label expressions instead of "a e<k>"
    ## ----------------------------------------------------------------------
    ## Arguments: x: numeric vector (e.g. axis tick locations)
    ## ----------------------------------------------------------------------
    ## Author: Martin Maechler, Date: 7 May 2004; 24 Jan 2006
    eT <- floor(log10(abs(x)) + 10^-digits.fuzz) # x == 0 case is dealt with below
    mT <- signif(x / 10^eT, digits.fuzz)
    ss <- vector("list", length(x))
    for(i in seq(along = x))
        ss[[i]] <-
            if(x[i] == 0) quote(0)
            else if(drop.1 && mT[i] ==  1) substitute( 10^E, list(E = eT[i]))
            else if(drop.1 && mT[i] == -1) substitute(-10^E, list(E = eT[i]))
            else substitute(A %*% 10^E, list(A = mT[i], E = eT[i]))
    do.call("expression", ss)
}

axTexpr <- function(side, at = axTicks(side, axp=axp, usr=usr, log=log),
                    axp = NULL, usr = NULL, log = NULL, drop.1 = FALSE)
{
    ## Purpose: Do "a 10^k" labeling instead of "a e<k>"
    ## -------------------------------------------------
    ## Arguments: as for axTicks()
    pretty10exp(at, drop.1)
}

### TODO:
###
### Myaxis(.)  function with at least two options ("engineering/not")
### Really wanted: allow   xaxt = "p" (pretty) or "P" (pretty, "Engineer")
### FIXME(2):  max.at is only needed because  axTicks() is sometimes too large
eaxis <- function(side, at = if(log && getRversion() >= "2.14.0")
                  axTicks(side, log=log, nintLog=nintLog) else
                  axTicks(side, log=log),
                  labels = NULL, log = NULL,
                  f.smalltcl = 3/5, at.small = NULL, small.mult = NULL,
                  draw.between.ticks = TRUE,
                  outer.at = TRUE, drop.1 = TRUE, las = 1,
                  nintLog = max(10, par("lab")[2L - is.x]),
                  max.at = Inf,...)
{
    ## Purpose: "E"xtended, "E"ngineer-like (log-)axis
    ## ----------------------------------------------------------------------
    ## Author: Martin Maechler, Date: 13 Oct 2007
    is.x <- side%%2 == 1
    if(is.null(log)) {
        XY <- function(ch) paste(if (is.x) "x" else "y", ch, sep = "")
        log <- par(XY("log"))
    }
    if(is.finite(max.at <- round(max.at))) { ## "thin the 'at' values
	if(max.at < 1) stop("'max.at' must be >= 1")
	at <- quantile(at, (0:max.at)/max.at, names = FALSE,
		       type = 3) ## <-- ensure that order statistics are used
	if(!log && is.null(at.small) &&
	   { d <- diff(at)
	     any(abs(diff(d)) > 1e-3 * mean(d))}) ## at	 is not equidistant
	    at.small <- FALSE
    }
    ## use expression (i.e. plotmath) if 'log' or exponential format:
    use.expr <- log || format.info(as.numeric(at), digits=7)[3] > 0
    if(is.null(labels))
	labels <- if(use.expr) pretty10exp(at, drop.1=drop.1) else TRUE
    else if(length(labels) == 1 && is.na(labels)) # no 'plotmath'
	labels <- TRUE
    axis(side, at = at, labels = labels, las=las, ...)
    if(log) {
	l1 <- (lat <- log10(at)) %% 1 ##  the 10^k ones
	l.int <- l1 < 1e-5 | l1 > 1 - 1e-5
	if(draw.between.ticks && all(l.int)) {
	    ## check if have "thinned" but still want to draw ticks
	    if(any(diff(lat <- sort(round(lat, 5))) > 1)) {
		at <- 10^(lat[1]:lat[length(lat)])
		axis(side, at = at, labels = FALSE, las=las, ...)
	    }
	}
    }
    if(is.null(at.small)) { ## create smart default, using small.mult
	at.small <-
	    if(log) {
		if(!all(l.int)) at <- at[l.int]
		if(is.null(small.mult)) small.mult <- 9
		if(length(at))
		    outer(2:small.mult, c(if(outer.at) at[1]/10, at))
	    } else {
                ## assumes that 'at' is equidistant
                d <- diff(at <- sort(at))
                if(any(abs(diff(d)) > 1e-3 * (dd <- mean(d))))
                    stop("'at' is not equidistant")
                if(is.null(small.mult)) {
                    ## look at 'dd' , e.g. in {5, 50, 0.05, 0.02 ..}
                    d. <- dd / 10^floor(log10(dd))
                    small.mult <- {
                        if(d. %% 5 == 0) 5
                        else if(d. %% 4 == 0) 4
                        else if(d. %% 2 == 0) 2
                        else if(d. %% 3 == 0) 3
                        else if(d. %% 0.5 == 0) 5
                        else 2 }
                }
                outer(1:(small.mult-1)/small.mult * dd,
                      c(if(outer.at) at[1]-dd, at), "+")
            }
        ##
        if(outer.at) { # make sure 'at.small' remain inside "usr"
            p.u <- sort(par("usr")[if(is.x) 1:2 else 3:4])
            if(log) p.u <- 10^p.u
            at.small <- at.small[p.u[1] <= at.small & at.small <= p.u[2]]
        }
    }
    if(is.numeric(at.small) && any(is.finite(at.small))) ## can use  NA or FALSE to suppress
	axis(side, at = at.small, label = FALSE,
	     tcl = f.smalltcl * par("tcl"))
}
