% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{sfc_linestring}
\alias{sfc_linestring}
\title{sfc LINESTRING}
\usage{
sfc_linestring(
  obj = NULL,
  x = NULL,
  y = NULL,
  z = NULL,
  m = NULL,
  linestring_id = NULL
)
}
\arguments{
\item{obj}{sorted matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{linestring_id}{column of ids for linestrings}
}
\value{
\code{sfc} object of LINESTRING geometries
}
\description{
constructs sfc of MULTIPOINT objects
}
\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\examples{

x <- matrix( c(1:4), ncol = 2 )
sfc_linestring( x )

x <- data.frame( id = 1:2, x = 1:2, y = 2:1 )
sfc_linestring( x )
sfc_linestring( x, x = "x", y = "y" )
sfc_linestring( x, x = "y", y = "x" )
sfc_linestring( x, linestring_id = "id", x = "x", y = "y")

df <- data.frame(
  id = c(1,1,1,1,2,2,2)
  , x = 1:7
  , y = 7:1
  , z = 14:8
  , m = 8:14
)

sfc_linestring(df, x = "x", y = "y", linestring_id = "id")
sfc_linestring(df, x = "x", y = "y", z = "z", linestring_id = "id")
sfc_linestring(df, x = "x", y = "y", m = "m", linestring_id = "id")
sfc_linestring(df, x = "x", y = "y", z = "z", m = "m", linestring_id = "id")

}
