% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp-ellipse.R
\name{ellipse}
\alias{ellipse}
\alias{st_ellipse}
\title{Create an Ellipse}
\usage{
ellipse(x = 0, y = 0, sx = 2, sy = 1, rotation = 0, n = 100)

st_ellipse(geometry, sx, sy, rotation = 0, n = 100)
}
\arguments{
\item{x}{longitude of center point}

\item{y}{latitude of center point}

\item{sx}{radius of major axis}

\item{sy}{radius of minor axis}

\item{rotation}{the degree of rotation of the ellipse}

\item{n}{the number of coordinates to generate for the ellipse}

\item{geometry}{an sf \code{ST_POINT} geometry. Can be \code{sfg}, \code{sfc}, or \code{sf} object}
}
\value{
an sf object
}
\description{
Generate an ellipse from center coordinates, major and minor axis radii, and angle rotation.
}
\details{
\code{\link[=ellipse]{ellipse()}} returns a matrix of point locations defining the ellipse. \code{\link[=st_ellipse]{st_ellipse()}} returns an sf object with LINE geography of the ellipse. Increasing n increases the number of points generated to define the ellipse shape.

\code{\link[=ellipse]{ellipse()}} function is adapted from \code{ggVennDiagram}.
}
\examples{
ellipse(n = 10)
st_ellipse(sf::st_point(c(0, 0)), sx = 10, sy = 10)
}
