% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{st_transform}
\alias{st_transform}
\alias{st_transform}
\alias{st_transform.sfc}
\alias{st_transform}
\alias{st_transform.sf}
\alias{st_transform}
\alias{st_transform.sfg}
\alias{st_transform}
\alias{st_proj_info}
\title{Transform or convert coordinates of simple feature}
\usage{
st_transform(x, crs, ...)

\method{st_transform}{sfc}(x, crs, ..., partial = TRUE, check = FALSE)

\method{st_transform}{sf}(x, crs, ...)

\method{st_transform}{sfg}(x, crs, ...)

st_proj_info(type = "proj")
}
\arguments{
\item{x}{object of class sf, sfc or sfg}

\item{crs}{coordinate reference system: integer with the epsg code, or character with proj4string}

\item{...}{ignored}

\item{partial}{logical; allow for partial projection, if not all points of a geometry can be projected (corresponds to setting environment variable \code{OGR_ENABLE_PARTIAL_REPROJECTION} to \code{TRUE})}

\item{check}{logical; perform a sanity check on resulting polygons?}

\item{type}{character; one of \code{proj}, \code{ellps}, \code{datum} or \code{units}}
}
\description{
Transform or convert coordinates of simple feature
}
\details{
transforms coordinates of object to new projection. Features that cannot be tranformed are returned as empty geometries.

the st_transform method for sfg objects assumes that the crs of the object is available as an attribute of that name.

\code{st_proj_info} lists the available projections, ellipses, datums or units supported by the Proj.4 library
}
\examples{
p1 = st_point(c(7,52))
p2 = st_point(c(-30,20))
sfc = st_sfc(p1, p2, crs = "+init=epsg:4326")
sfc
st_transform(sfc, "+init=epsg:3857")
st_transform(st_sf(a=2:1, geom=sfc), "+init=epsg:3857")
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_area(nc[1,]) # area, using geosphere::areaPolygon
st_area(st_transform(nc[1,], 32119)) # NC state plane, m
st_area(st_transform(nc[1,], 2264)) # NC state plane, US foot
library(units)
as.units(st_area(st_transform(nc[1,], 2264)), make_unit("m")^2)
st_transform(structure(p1, proj4string = "+init=epsg:4326"), "+init=epsg:3857")
st_proj_info("datum")
}
