% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos}
\alias{geos}
\alias{st_area}
\alias{st_boundary}
\alias{st_buffer}
\alias{st_centroid}
\alias{st_combine}
\alias{st_contains}
\alias{st_convex_hull}
\alias{st_covered_by}
\alias{st_covers}
\alias{st_crosses}
\alias{st_difference}
\alias{st_disjoint}
\alias{st_distance}
\alias{st_equals}
\alias{st_equals_exact}
\alias{st_intersection}
\alias{st_intersects}
\alias{st_is_simple}
\alias{st_is_valid}
\alias{st_length}
\alias{st_overlaps}
\alias{st_polygonize}
\alias{st_relate}
\alias{st_segmentize}
\alias{st_simplify}
\alias{st_sym_difference}
\alias{st_touches}
\alias{st_triangulate}
\alias{st_union}
\alias{st_within}
\title{Geometric operations on (pairs of) simple feature geometries}
\usage{
st_is_valid(x)

st_area(x)

st_length(x)

st_is_simple(x)

st_distance(x, y = x)

st_relate(x, y)

st_intersects(x, y, sparse = TRUE)

st_disjoint(x, y, sparse = TRUE)

st_touches(x, y, sparse = TRUE)

st_crosses(x, y, sparse = TRUE)

st_within(x, y, sparse = TRUE)

st_contains(x, y, sparse = TRUE)

st_overlaps(x, y, sparse = TRUE)

st_equals(x, y, sparse = TRUE)

st_covers(x, y, sparse = TRUE)

st_covered_by(x, y, sparse = TRUE)

st_equals_exact(x, y, par, sparse = TRUE)

st_buffer(x, dist, nQuadSegs = 30)

st_boundary(x)

st_convex_hull(x)

st_simplify(x, preserveTopology = FALSE, dTolerance = 0)

st_triangulate(x, dTolerance = 0, bOnlyEdges = FALSE)

st_polygonize(mlst)

st_centroid(x)

st_segmentize(x, dfMaxLength)

st_combine(x)

st_intersection(x, y0)

st_union(x, y0)

st_difference(x, y0)

st_sym_difference(x, y0)
}
\arguments{
\item{x}{first simple feature (sf) or simple feature geometry (sfc) collection}

\item{y}{second simple feature (sf) or simple feature geometry (sfc) collection}

\item{sparse}{logical; should a sparse matrix be returned (TRUE) or a dense matrix?}

\item{par}{numeric; parameter used for "equals_exact" (margin) and "is_within_distance"}

\item{dist}{buffer distance}

\item{nQuadSegs}{integer; number of segments per quadrant (fourth of a circle)}

\item{preserveTopology}{logical; carry out topology preserving simplification?}

\item{dTolerance}{numeric; tolerance parameter}

\item{bOnlyEdges}{logical; if TRUE, return lines, else return polygons}

\item{mlst}{object of class \code{MULTILINESTRING} or geometry list-column containing these}

\item{dfMaxLength}{numeric; max length of a line segment}

\item{y0}{object of class \code{sfc} which is merged, using \code{c.sfg} (\link{st}), before intersection etc. with it is computed}
}
\value{
matrix (sparse or dense); if dense: of type \code{character} for \code{relate}, \code{numeric} for \code{distance}, and \code{logical} for all others; matrix has dimension \code{x} by \code{y}; if sparse (only possible for those who return logical in case of dense): return list of length length(x) with indices of the TRUE values for matching \code{y}.

st_area returns the area of a geometry, in the coordinate reference system used

st_length returns the length of a geometry, in the coordinate reference system used

st_is_simple and st_is_valid return a logical vector

st_distance returns a dense numeric matrix of dimension length(x) by length(y)

st_relate returns a dense \code{character} matrix; element [i,j] has nine characters, refering to the DE9-IM relationship between x[i] and y[j], encoded as IxIy,IxBy,IxEy,BxIy,BxBy,BxEy,ExIy,ExBy,ExEy where I refers to interior, B to boundary, and E to exterior, and e.g. BxIy the dimensionality of the intersection of the the boundary of x[i] and the interior of y[j], which is one of {0,1,2,F}, digits denoting dimensionality, F denoting not intersecting.

st_intersects ...  st_equals_exact return a sparse or dense logical matrix with rows and columns corresponding to the number of geometries (or rows) in x and y, respectively

st_buffer ... st_segmentize return an \link{sfc} object with the same number of geometries as in \code{x}

\code{st_union(x)} unions geometries.  Unioning a set of overlapping polygons has the effect of merging the areas (i.e. the same effect as iteratively unioning all individual polygons together). Unioning a set of LineStrings has the effect of fully noding and dissolving the input linework. In this context "fully noded" means that there will be a node or endpoint in the output for every endpoint or line segment crossing in the input. "Dissolved" means that any duplicate (e.g. coincident) line segments or portions of line segments will be reduced to a single line segment in the output.  Unioning a set of Points has the effect of merging al identical points (producing a set with no duplicates). If \code{y0} in a call to \code{st_union} is not missing, each of the geometries in \code{x} are unioned to the combination of \code{y0}.
}
\description{
Geometric operations on (pairs of) simple feature geometries
}
\details{
requires GEOS version 3.4 or above

\code{st_combine} combines geometries without resolving borders. 
st_combine(nc)
}
\examples{
p1 = st_point(c(0,0))
p2 = st_point(c(2,2))
pol1 = st_polygon(list(rbind(c(0,0),c(1,0),c(1,1),c(0,1),c(0,0)))) - 0.5
pol2 = pol1 + 1
pol3 = pol1 + 2
st_relate(st_sfc(p1,p2), st_sfc(pol1, pol2, pol3))
nc = st_read(system.file("shape/nc.shp", package="sf"), "nc", crs = 4267)
plot(st_convex_hull(nc))
plot(nc, border = grey(.5))
mls = st_multilinestring(list(matrix(c(0,0,0,1,1,1,0,0),,2,byrow=TRUE)))
x = st_polygonize(mls)
plot(nc, axes = TRUE)
plot(st_centroid(nc), add = TRUE, pch = 3)
plot(st_union(nc))
}

