% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{forecast.setartree}
\alias{forecast.setartree}
\title{Forecast method for SETAR-Tree fits}
\usage{
\method{forecast}{setartree}(object, newdata, h = 5, ...)
}
\arguments{
\item{object}{An object of class \code{\link{setartree}} which is a trained SETAR-Tree model.}

\item{newdata}{A list of time series which needs forecasts or a dataframe/matrix of new instances which need predictions.}

\item{h}{The required number of forecasts (forecast horizon). This parameter is only required when \code{newdata} is a list of time series. Default value is 5.}

\item{...}{Other arguments.}
}
\value{
If \code{newdata} is a list of time series, then an object of class \code{mforecast} is returned.
The \code{plot} or \code{autoplot} functions in the R \code{forecast} package can then be used to produce a plot of any time series in the returned object which contains the following properties.
\item{method}{A vector containing the name of the forecasting method ("SETAR-Tree").}
\item{forecast}{A list of objects of class \code{forecast}.
Each list object is corresponding with a time series and its forecasts.
Each list object contains 4 properties:
method (the name of the forecasting method, SETAR-Tree, as a character string),
x (the original time series),
mean (point forecasts as a time series) and
series (the name of the series as a character string).}
If \code{newdata} is a dataframe/matrix, then a vector containing the prediction of each instance is returned.
}
\description{
Obtains forecasts for a given set of time series or a dataframe/matrix of new instances from a fitted SETAR-Tree model.
}
\examples{
\donttest{
# Obtaining forecasts for a list of time series
tree1 <- setartree(chaotic_logistic_series)
forecast(tree1, chaotic_logistic_series)

# Obtaining forecasts for a set of test instances
tree2 <- setartree(data = web_traffic_train[,-1],
                   label = web_traffic_train[,1],
                   stopping_criteria = "both",
                   categorical_covariates = "Project")
forecast(tree2, web_traffic_test)
}

}
