% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asInterval.R
\name{as.Interval}
\alias{as.Interval}
\alias{as.Interval.Set}
\alias{as.Interval.Interval}
\alias{as.Interval.list}
\alias{as.Interval.data.frame}
\alias{as.Interval.matrix}
\alias{as.Interval.numeric}
\alias{as.Interval.ConditionalSet}
\title{Coercion to R6 \code{Interval}}
\usage{
as.Interval(object)

\method{as.Interval}{Set}(object)

\method{as.Interval}{Interval}(object)

\method{as.Interval}{list}(object)

\method{as.Interval}{data.frame}(object)

\method{as.Interval}{matrix}(object)

\method{as.Interval}{numeric}(object)

\method{as.Interval}{ConditionalSet}(object)
}
\arguments{
\item{object}{object to coerce}
}
\description{
Coerces object to an R6 \link{Interval}.
}
\details{
\itemize{
\item \code{as.Interval.list/as.Interval.data.frame} - Assumes the \code{list}/\code{data.frame} has named items/columns:
\verb{lower, upper, type, class}.
\item \code{as.Interval.numeric} - If the \code{numeric} vector is a continuous interval with no breaks then coerces to an \link{Interval}
with: \verb{lower = min(object), upper = max(object), class = "integer"}. Ordering is ignored.
\item \code{as.Interval.matrix} - Tries coercion via \link{as.Interval.numeric} on the first column of the matrix.
\item \code{as.Interval.Set} - First tries coercion via \link{as.Interval.numeric}, if possible wraps result in a \link{Set}.
\item \code{as.Interval.FuzzySet} - Tries coercion via \link{as.Interval.Set} on the support of the \link{FuzzySet}.
}
}
\seealso{
\link{Interval}

Other coercions: 
\code{\link{as.FuzzySet}()},
\code{\link{as.Set}()}
}
\concept{coercions}
