% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetWrapper_ExponentSet.R
\name{ExponentSet}
\alias{ExponentSet}
\title{Set of Exponentiations}
\value{
R6 object of class ExponentSet, inheriting from SetWrapper.
}
\description{
ExponentSet class for symbolic exponentiation of mathematical sets.
}
\details{
The purpose of this class is to provide a symbolic representation for the exponentiation of sets that
cannot be represented in a simpler class. Whilst this is not an abstract class, it is not recommended to construct
this class directly but via the set operation methods.
}
\section{Constructor}{
 \code{ExponentSet$new(set, power)}
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{set} \tab list \tab Set to wrap. \cr

\code{lower} \tab Set \tab Lower limit of set. \cr
\code{upper} \tab Set \tab Upper limit of set. \cr
\code{type} \tab character \tab Type of set braces. \cr
}
}

\section{Constructor Details}{
 It is not recommended to construct this class directly.
}

\section{Public Fields}{

\tabular{ll}{
\strong{Field} \tab \strong{Link} \cr
\code{power} \tab \link{power} \cr

\code{wrappedSets} \tab \link{wrappedSets} \cr
\code{class} \tab \link{class} \cr
\code{elements} \tab \link{elements} \cr
\code{length} \tab \link{length} \cr
\code{lower} \tab \link{lower} \cr
\code{upper} \tab \link{upper} \cr
\code{max} \tab \link{max} \cr
\code{min} \tab \link{min} \cr
\code{range} \tab \link{range} \cr
\code{properties} \tab \link{properties} \cr
\code{traits} \tab \link{traits} \cr
\code{type} \tab \link{type} \cr
\code{universe} \tab \link{universe}
}
}

\section{Public Methods}{

\tabular{ll}{

\strong{Comparison Methods} \tab \strong{Link} \cr
\code{contains(x, all = FALSE, bound = NULL)} \tab \link{contains} \cr
\code{equals(x, all = FALSE)} \tab \link{equals} \cr
\code{isSubset(x, proper = FALSE, all = FALSE)} \tab \link{isSubset} \cr
\tab \cr \tab \cr \tab \cr
\strong{Mathematical Methods} \tab \strong{Link} \cr
\code{absComplement()} \tab \link{absComplement} \cr
\tab \cr \tab \cr \tab \cr
\strong{Representation Methods} \tab \strong{Link} \cr
\code{strprint(n = 2)} \tab \link{strprint} \cr
\code{print(n = 2)} \tab \link{print} \cr
\code{summary(n = 2)} \tab \link{summary} \cr
}
}

\seealso{
Set operations: \link{setunion}, \link{setproduct}, \link{setpower}, \link{setcomplement}, \link{setsymdiff},  \link{powerset}, \link{setintersect}

Other wrappers: 
\code{\link{ComplementSet}},
\code{\link{PowersetSet}},
\code{\link{ProductSet}},
\code{\link{UnionSet}}
}
\concept{wrappers}
