% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{sst_au_get_summary}
\alias{sst_au_get_summary}
\title{Website audit summary}
\usage{
sst_au_get_summary(api_token, report_id = NULL)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{report_id}{(required) ID of the audit report to get data from.}
}
\value{
Returns the basic metrics for audited website.
}
\description{
Returns the basic stats for the finished audit returns, including number of
checked pages, issues by priority, domain optimization score.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/516-audit-basic-information-getbasicinfo/}{here}.
}

\section{API credits consumption}{
 0.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_au_get_summary(
  api_token = api_key,
  report_id = report_id
  )$data
}
}
