% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_id.R
\name{set_id_var}
\alias{set_id_var}
\title{Specify person ID column}
\usage{
set_id_var(object, id = "index_id", standardize = TRUE, ...)
}
\arguments{
\item{object}{a \link{data.frame}}

\item{id}{\link{character} string at least partially matching a column
in \code{object}}

\item{standardize}{whether to rename the column specified by \code{id}
to "id"}

\item{...}{unused}
}
\value{
a modified version of \code{object}
}
\description{
Sets the \code{id_var} metadata attribute of \code{object}
}
\examples{
serocalculator_example("example_pop_data.rds") |>
  readr::read_rds() |>
    set_id_var(id = "index_id") |>
    attr("id_var")
}
\keyword{internal}
