% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_smacof.R
\name{register_smacof}
\alias{register_smacof}
\alias{registersmacof}
\alias{smacof}
\title{Register Seriation Methods from Package smacof}
\usage{
register_smacof()
}
\value{
Nothing.
}
\description{
Registers the \code{"MDS_smacof"} method for \code{\link[=seriate]{seriate()}} based on multidimensional
scaling using stress majorization and the corresponding \code{"smacof_stress0"}
criterion implemented in package smacof (de Leeuw & Mair, 2009).
}
\details{
Seriation method \code{"smacof"} implements stress majorization with several transformation functions.
These functions are passed on as the type control parameter. We default
to \code{"ratio"}, which together with \code{"interval"} performs metric MDS.
\code{"ordinal"} can be used
for non-metric MDS. See \code{\link[smacof:smacofSym]{smacof::smacofSym()}} for details on the
control parameters.

The corresponding criterion called \code{"smacof_stress0"} is also registered.
There additional parameter \code{type} is used to specify the used
transformation function. It should agree with the function used for seriation.
See \code{\link[smacof:stress0]{smacof::stress0()}} for details on the stress calculation.

\strong{Note:} Package \pkg{smacof} needs to be installed.
}
\examples{
\dontrun{
register_smacof()

get_seriation_method("dist", "MDS_smacof")

d <- dist(random.robinson(20, pre = TRUE))

## use Banded AR form with default clustering (complete-link)
o <- seriate(d, "MDS_smacof", verbose = TRUE)
pimage(d, o)

# recalculate stress for the order
MDS_stress(d, o)

# ordinal MDS. stress needs to be calculated using the correct type with stress0
o <- seriate(d, "MDS_smacof", type = "ordinal", verbose = TRUE)
criterion(d, o, method = "smacof_stress0", type = "ordinal")
}
}
\references{
Jan de Leeuw, Patrick Mair (2009). Multidimensional Scaling Using Majorization: SMACOF in R.
\emph{Journal of Statistical Software, 31(3),} 1-30. \doi{10.18637/jss.v031.i03}
}
\seealso{
Other seriation: 
\code{\link{register_DendSer}()},
\code{\link{register_GA}()},
\code{\link{register_optics}()},
\code{\link{register_tsne}()},
\code{\link{register_umap}()},
\code{\link{registry_for_seriaiton_methods}},
\code{\link{seriate}()},
\code{\link{seriate_best}()}
}
\concept{seriation}
\keyword{cluster}
\keyword{optimize}
