% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{readBGENToMatrixByGene}
\alias{readBGENToMatrixByGene}
\title{Read a gene from BGEN file and return a genotype matrix}
\usage{
readBGENToMatrixByGene(fileName, geneFile, geneName)
}
\arguments{
\item{fileName}{character, represents an input BGEN file (Bgzipped, with Tabix index)}

\item{geneFile}{character, a text file listing all genes in refFlat format}

\item{geneName}{character vector, which gene(s) to be extracted}
}
\value{
genotype matrix
}
\description{
Read a gene from BGEN file and return a genotype matrix
}
\examples{
fileName = system.file("bgen/all.anno.filtered.extract.bgen", package = "seqminer")
geneFile = system.file("vcf/refFlat_hg19_6col.txt.gz", package = "seqminer")
cfh <- readBGENToMatrixByGene(fileName, geneFile, "CFH")
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
